<?php

use DeviceDetector\DeviceDetector;
use DeviceDetector\Parser\Device\DeviceParserAbstract;
use GeoIp2\Database\Reader;

App::uses('AppModel', 'Model');

class Stat extends AppModel
{

    public $belongsTo = array( 'User', 'Link' );

    public function get_geo($ip)
    {
        $reader = new Reader(APP . 'app-files' . DS . 'geoip2' . DS . 'GeoLite2-City.mmdb');

        try {
            $record = $reader->city($ip);
            $geo = array(
                'continent' => ( trim($record->continent->name) ) ? $record->continent->name : 'Others',
                'country'   => ( trim($record->country->isoCode) ) ? $record->country->isoCode : 'Others',
                'state'     => ( trim($record->mostSpecificSubdivision->name) ) ? $record->mostSpecificSubdivision->name : 'Others',
                'city'      => ( trim($record->city->name) ) ? $record->city->name : 'Others',
                'location'  => $record->location->latitude . ',' . $record->location->longitude,
                'timezone'  => ( trim($record->location->timeZone) ) ? $record->location->timeZone : 'Others'
            );
        } catch (Exception $ex) {
            $geo = array(
                'continent' => 'Others',
                'country'   => 'Others',
                'state'     => 'Others',
                'city'      => 'Others',
                'location'  => 'Others',
                'timezone'  => 'Others'
            );
        }

        return $geo;
    }

    public function getUserAgent()
    {

        // OPTIONAL: Set version truncation to none, so full versions will be returned
        // By default only minor versions will be returned (e.g. X.Y)
        // for other options see VERSION_TRUNCATION_* constants in DeviceParserAbstract class
        DeviceParserAbstract::setVersionTruncation(DeviceParserAbstract::VERSION_TRUNCATION_NONE);

        $dd = new DeviceDetector(env('HTTP_USER_AGENT'));

        // OPTIONAL: Set caching method
        // By default static cache is used, which works best within one php process (memory array caching)
        // To cache across requests use caching in files or memcache
        App::uses('UaCache', 'Lib');
        $dd->setCache(new UaCache());

        // OPTIONAL: If called, getBot() will only return true if a bot was detected  (speeds up detection a bit)
        $dd->discardBotInformation();

        // OPTIONAL: If called, bot detection will completely be skipped (bots will be detected as regular devices then)
        //$dd->skipBotDetection();

        $dd->parse();
        return $dd;
    }

    public function facebook_count($url)
    {
        App::uses('HttpSocket', 'Network/Http');
        $HttpSocket = new HttpSocket(array( 'ssl_verify_host' => false ));
        $query      = array( 'format' => 'json', 'urls' => $url );
        $response   = $HttpSocket->get('https://api.facebook.com/method/links.getStats', $query);
        $body       = json_decode($response->body);
        if (isset($body[ 0 ]->share_count)) {
            return intval($body[ 0 ]->share_count);
        } else {
            return 0;
        }
    }

    public function pinterest_count($url)
    {
        App::uses('HttpSocket', 'Network/Http');
        $HttpSocket = new HttpSocket(array( 'ssl_verify_host' => false ));
        $query      = array( 'source' => 6, 'url' => $url );
        $response   = $HttpSocket->get('http://widgets.pinterest.com/v1/urls/count.json', $query);
        $body       = preg_replace('/^receiveCount\((.*)\)$/', '\\1', $response->body);
        if (isset(json_decode($body)->count)) {
            return intval(json_decode($body)->count);
        }
        return 0;
    }

    public function linkedin_count($url)
    {
        App::uses('HttpSocket', 'Network/Http');
        $HttpSocket = new HttpSocket(array( 'ssl_verify_host' => false ));
        $query      = array( 'format' => 'json', 'url' => $url );
        $response   = $HttpSocket->get('https://www.linkedin.com/countserv/count/share', $query);
        $body       = json_decode($response->body);
        if (isset($body->count)) {
            return intval($body->count);
        }
        return 0;
    }

    public function stumbledupon_count($url)
    {
        App::uses('HttpSocket', 'Network/Http');
        $HttpSocket = new HttpSocket(array( 'ssl_verify_host' => false ));
        $query      = array( 'url' => $url );
        $response   = $HttpSocket->get('https://www.stumbleupon.com/services/1.01/badge.getinfo', $query);
        $body       = json_decode($response->body);
        if (isset($body->result->views)) {
            return intval($body->result->views);
        }
        return 0;
    }

    public function reddit_count($url)
    {
        App::uses('HttpSocket', 'Network/Http');
        $HttpSocket = new HttpSocket(array( 'ssl_verify_host' => false ));
        $query      = array( 'url' => $url );
        $response   = $HttpSocket->get('https://buttons.reddit.com/button_info.json', $query);
        $body       = json_decode($response->body, true);
        if (isset($body[ 'data' ][ 'children' ][ 0 ][ 'data' ][ 'score' ])) {
            return intval($body[ 'data' ][ 'children' ][ 0 ][ 'data' ][ 'score' ]);
        }
        return 0;
    }

    public function google_plus_count($url)
    {
        App::uses('HttpSocket', 'Network/Http');
        $HttpSocket = new HttpSocket(array( 'ssl_verify_host' => false ));

        // http://stackoverflow.com/a/21290110/1794834
        $query = array(
            'method'     => 'pos.plusones.get',
            'id'         => 'p',
            'params'     => array(
                "nolog"   => true,
                "id"      => $url,
                "source"  => "widget",
                "userId"  => "@viewer",
                "groupId" => "@self"
            ),
            'jsonrpc'    => '2.0',
            'key'        => 'p',
            'apiVersion' => 'v1'
        );

        $request = array(
            'header' => array( 'Content-Type' => 'application/json',
            )
        );

        $response = $HttpSocket->post('https://clients6.google.com/rpc?key=AIzaSyCKSbrvQasunBoV16zDH9R33D88CeLr9gQ', json_encode($query), $request);

        $data = json_decode($response->body, true);

        if (isset($data[ 'result' ][ 'metadata' ][ 'globalCounts' ][ 'count' ])) {
            return intval($data[ 'result' ][ 'metadata' ][ 'globalCounts' ][ 'count' ]);
        }
        return 0;
    }
}
